<?php
/**
* NOTA SOBRE LA LICENCIA DE USO DEL SOFTWARE
* 
* El uso de este software está sujeto a las Condiciones de uso de software que
* se incluyen en el paquete en el documento "Aviso Legal.pdf". También puede
* obtener una copia en la siguiente url:
* http://www.redsys.es/wps/portal/redsys/publica/areadeserviciosweb/descargaDeDocumentacionYEjecutables
* 
* Redsys es titular de todos los derechos de propiedad intelectual e industrial
* del software.
* 
* Quedan expresamente prohibidas la reproducción, la distribución y la
* comunicación pública, incluida su modalidad de puesta a disposición con fines
* distintos a los descritos en las Condiciones de uso.
* 
* Redsys se reserva la posibilidad de ejercer las acciones legales que le
* correspondan para hacer valer sus derechos frente a cualquier infracción de
* los derechos de propiedad intelectual y/o industrial.
* 
* Redsys Servicios de Procesamiento, S.L., CIF B85955367
*/

namespace Redsys\Redsys\Controller\Checkout;

use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Checkout\Model\Session;
use Magento\Checkout\Model\Cart;
use Magento\Quote\Api\Data\CartItemInterfaceFactory;

use Redsys\Redsys\Helper\OrderManager;

class Error extends  \Magento\Framework\App\Action\Action {
	protected $_resultPageFactory;
	protected $_session;
	protected $_cart;
	protected $_cartItemFactory;

	public function __construct(Context $context, PageFactory $resultPageFactory, Session $session, Cart $cart, CartItemInterfaceFactory $cartItemFactory) {
		$this->_resultPageFactory = $resultPageFactory;
		$this->_session = $session;
		$this->_cart = $cart;
		$this->_cartItemFactory = $cartItemFactory;
		return parent::__construct($context);
	}

	public function get_resultPageFactory() {
		return $this->_resultPageFactory;
	}

	public function get_session() {
		return $this->_session;
	}

	public function get_cart() {
		return $this->_cart;
	}

	public function get_cartItemFactory() {
		return $this->_cartItemFactory;
	}

	public function execute() {
		$resultPageFactory = $this->get_resultPageFactory();

		if(isset($_GET['restoreCart']) && $_GET['restoreCart'] == "1"){
			$session = $this->get_session();
			$order = $session->getLastRealOrder();
			$cart = $this->get_cart();
			$cartItemFactory = $this->get_cartItemFactory();
	
			OrderManager::RestoreCart($order, $cart, $cartItemFactory);
		}

		$resultPage = $resultPageFactory->create();
		$resultPage->getConfig()->getTitle()->prepend("Error procesando el pago");
		$resultPage->getLayout()->initMessages();
		$resultPage->getLayout()->getBlock('redsys_checkout_error')->setMessage("Se ha producido un error al procesar el pago.");
		return $resultPage;
	}
}
